
function out = DAS_US2(rf, no_ele, channelSpacing, speedSound,times)

% load('rf.mat');
% no_ele = 32;

ns = size(rf,1);   % number of samples
nl = size(rf,2);   % number of lines

% win = hanning(fulAprSz)';   % windowing used for apodization
% chnls = zeros(1,fulAprSz);  % will be filled with proper signal from each channel
sampleSpacing = (1/40e6*speedSound)*1000; % spacing between samples in photoacoustic imaging
% sampleFreq = 40e6;

postBF = zeros(ns,nl*times);

hlfapt = no_ele/2;

% win = hamming(round(hlfapt)*2+1)';
for r = 1:nl*times % final line
    %     RF(:,:) = RFframe(:,:,m);
    RF = rf;
    noise = max(max(RF))*randn(size(RF,1),size(RF,2));
%     RF = RF + noise;
    for j = 1:ns
        for i = r/times-hlfapt:r/times+hlfapt
            if i > 0 && i <= nl
                depth = j*(sampleSpacing);
%                                 depth = j*(sampleSpacing);
                width = (r/times-(i)) * channelSpacing;
                rad = sqrt((depth)^2 + width^2);
%                 delay = (rad - depth)/(sampleSpacing);
              delay = (rad - depth)/(sampleSpacing)*2;
                value = j+delay;
                f_value = floor(value);
                c_value = ceil(value);
                if delay == 0
                    postBF(j,r) = postBF(j,r) + RF(j,ceil(i));
                    %                     postBeamRF(j,i) = postBeamRF(j,i) + preBeamRF(j,n);
                elseif c_value < ns
                    y_c = RF(c_value,ceil(i));
                    y_f = RF(f_value,ceil(i));
                    alpha = (value - f_value)/(c_value - f_value);
                    if alpha >0 && alpha <1
                        y = (1-alpha)*y_f + alpha*y_c;
                        %                     postBeamRF(j,i) = postBeamRF(j,i) + preBeamRF2(round(j+2*delays(j,n)),n);
                        postBF(j,r) = postBF(j,r) + y;
                    else
                        postBF(j,r) = postBF(j,r) + RF(j,ceil(i));
                    end
                    
                end
            end
        end
    end
end

out = postBF;
